function onCreate()
	local downScroll = getPropertyFromClass("ClientPrefs", "downScroll");

	if not downScroll then
		makeLuaText("title_text", "", 1000, 140, 580);
		makeLuaText("description_text", "", 1000, 140, 610);
	else
		makeLuaText("description_text", "", 1000, 140, 45);
		makeLuaText("title_text", "", 1000, 140, 15);
	end

	setProperty("title_text.alpha", 0);
	setTextSize("title_text", 32);
	addLuaText("title_text", true);

	setProperty("description_text.alpha", 0);
	setTextSize("description_text", 20);
	addLuaText("description_text", true);
end

function onCreatePost()
	setProperty("iconP1.alpha", 0);
	setProperty("iconP2.alpha", 0);
end

function onEvent(n, v1, v2)
	if n == "Set Song Info" then
		setTextString("title_text", v1);
		setTextString("description_text", v2);
	end
end

function onSongStart()
	doTweenAlpha("title_tween_in", "title_text", 1, 1.25, "expoInOut");
	doTweenAlpha("desc_tween_in", "description_text", 1, 1.25, "expoInOut");
end

function onBeatHit()
	if curBeat == 12 then
		doTweenAlpha("title_tween_out", "title_text", 0, 1.25, "expoInOut");
		doTweenAlpha("desc_tween_out", "description_text", 0, 1.25, "expoInOut");
	end

	if curBeat == 14 then
		doTweenAlpha("iconP1_tween_in", "iconP1", 1, 1.25, "expoInOut");
		doTweenAlpha("iconP2_tween_in", "iconP2", 1, 1.25, "expoInOut");
	end
end