local modchart = true

local player1 = 'fw clover pov';
local player2 = 'fleetwayclover';
local bgs = {[player2] = 'fleet', [player1] = 'sonic'}
local glows = {'glow-nicky', 'glow-anne'}

function onCreate()
	setPropertyFromClass('ClientPrefs', 'middleScroll', false)

	-- FX stuff
	makeAnimatedLuaSprite('fx', 'bg/vintage', 0, 0)
	addAnimationByPrefix('fx', 'idle', 'idle', 16, true)
	scaleObject('fx', 3, 3)
	setObjectCamera('fx', 'camHud')
	objectPlayAnimation('fx', 'idle', true)
	setProperty('fx.alpha', 0)

	for k,v in pairs(bgs) do
		makeLuaSprite(bgs[k], 'bg/'..bgs[k], -275, -200);
		setScrollFactor(bgs[k], 0.2, 0.2);
		addLuaSprite(bgs[k], false);
	end

	makeLuaSprite("dimmer", nil, -160, -90);
	makeGraphic("dimmer", 1600, 900, "000000");
	setScrollFactor("dimmer", 0, 0);
	setProperty("dimmer.alpha", 0);
	addLuaSprite("dimmer", false);

	setProperty(bgs[player2]..".alpha", 0)
	setProperty(bgs[player1]..".alpha", 1)

	addCharacterToList(player2, 'boyfriend')
	precacheSound('stat')

	setPropertyFromClass('GameOverSubstate', 'characterName', 'sonic')
end

function onCreatePost()
    triggerEvent("followchars", 0, 0);

    for i = 1, 4 do
        setPropertyFromGroup('strumLineNotes', i - 1, 'x', -400);
    end
end

function onSongStart()
	addLuaSprite('fx', true)
end

function onUpdate(elapsed)
	if modchart then 
		for i = 0,3 do
			setPropertyFromGroup('strumLineNotes', i, 'alpha', 0)
			
			local playerStrumX = getPropertyFromGroup('strumLineNotes', i + 4, "x")
			local playerStrumY = getPropertyFromGroup('strumLineNotes', i + 4, "y")

			-- setPropertyFromGroup('strumLineNotes', i, 'x', playerStrumX)
			-- setPropertyFromGroup('strumLineNotes', i, 'y', playerStrumY)
		end
	end
	
	-- Camera movement code moved to NoteHitHandler
end

function onStartCountdown()
	setProperty('gf.alpha', 0)
	setProperty('dad.alpha', 0)
	setProperty('iconP2.visible', false)

	return Function_Continue
end

function onStepHit()
	if curStep == 10 then
		modchart = false
	end

	-- if curStep == 384 or curStep == 768 or curStep == 1151 or curStep == 1172 or curStep == 1276 or curStep == 1282 or curStep == 1304 or curStep == 1536 or curStep == 1922 or curStep == 1937 or curStep == 1943 or curStep == 1956 then
	-- 	fleetON()
	-- 	triggerEvent("Toggle Fleetway");
	-- end
	
	-- if curStep == 640 or curStep == 1024 or curStep == 1154 or curStep == 1176 or curStep == 1279 or curStep == 1300 or curStep == 1408 or curStep == 1792 or curStep == 1926 or curStep == 1940 or curStep == 1946 or curStep == 1960 then
	-- 	fleetOFF()
	-- 	triggerEvent("Toggle Fleetway");
	-- end
end

function onEvent(n, v1, v2)
	if n == "Fleetway Swap" then
		if v1 == "on" then
			fleetON(d);
		else
			local d = "";
			if v2 ~= nil then d = v2 end
			fleetOFF(d);
		end

		triggerEvent("Toggle Fleetway");
	end
end

function fleetON()
	setProperty('fx.alpha', 0.8)
	setProperty(bgs[player2]..'.alpha', 1)
	setProperty(bgs[player1]..'.alpha', 0)
	doTweenAlpha('fleetON', 'fx', 0, 1, 'linear')
	playSound('stat', 0.3)
	triggerEvent('Change Character', 0, player2)
	setProperty("iconP1.flipX", true);
end

function fleetOFF(d)
	setProperty('fx.alpha', 0.8)
	setProperty(bgs[player2]..'.alpha', 0)
	setProperty(bgs[player1]..'.alpha', 1)
	doTweenAlpha('fleetON', 'fx', 0, 1, 'linear')
	playSound('stat', 0.3)
	setProperty("iconP1.flipX", false);

	if d == "" then triggerEvent('Change Character', 0, player1); end
end

function onGameOver()
	modchart = false
	return Function_Continue;
end

-- borrowed code
function keysOf(tab)
	local keyset = {}
	for k,v in pairs(tab) do
	  	keyset[#keyset + 1] = k
	end
	return keyset
  end